on run(argv)
    -- 获取安装包路径
    if (count of argv) = 0 then
        error "未提供参数"
    end if
    set appPath to item 1 of argv

    -- 检查路径是否以.app结尾
    if appPath does not end with ".app" then
        error "提供的路径不是一个.app应用程序: " & appPath
    end if
    
    -- 获取应用程序名称（不带.app后缀）
    set {tid, AppleScript's text item delimiters} to {AppleScript's text item delimiters, "/"}
    set pathComponents to text items of appPath
    set AppleScript's text item delimiters to tid
    set appName to last item of pathComponents
    set appName to text 1 thru ((length of appName) - 4) of appName -- 去掉.app后缀
    
    -- 启动应用程序
    try
        tell application appPath to activate
    on error errMsg
        error "无法启动应用程序: " & errMsg
    end try

    -- 找进程
    set startTime to current date
    tell application "System Events"
        set isFound to false
        repeat while (current date) - startTime < 10
            if exists process appName then
                set isFound to true
                exit repeat
            end if
            delay 0.1
        end repeat

        if not isFound then
            return "process not found"
        end if 

        -- 等待授权
        set startTime to current date
        repeat
            try
                if not exists process appName then
                    return "process quit before allow"
                end if
                
                tell application "System Events" 
                    keystroke "t" using command down
                end tell
                exit repeat
            on error
                if (current date) - startTime > 60 then
                    if exists process appName then
                        return "not allow, but process still"
                    end if
                    return "not allow"
                end if
                delay 0.1
            end try
        end repeat

        -- 按按钮, 等待直至安装进程退出
        repeat
            if not exists process appName then
                return "process quit"
            end if

            tell process appName
                -- set frontmost to true
                -- delay 0.1
                tell window 1
                    try
                        set allButtons to every button
                    
                        -- 初始化右下角按钮和最大坐标
                        set bottomRightButton to missing value
                        set maxX to 0
                        set maxY to 0
                        
                        -- 遍历所有按钮，找出最右下角的
                        repeat with btn in allButtons
                            set btnPosition to position of btn
                            set {btnX, btnY} to {item 1 of btnPosition, item 2 of btnPosition}
                            
                            -- 检查是否比当前记录的更靠右下
                            if btnX ≥ maxX and btnY ≥ maxY then
                                set maxX to btnX
                                set maxY to btnY
                                set bottomRightButton to btn
                            end if
                        end repeat
                        
                        -- 点击最右下角的按钮
                        if bottomRightButton is not missing value then
                            click bottomRightButton
                        end if
                    on error
                        delay 0.1
                    end try
                end tell
            end tell
            
            try
                tell process appName
                    set targetCheckbox to first checkbox of window 1 whose value is 0
                    click targetCheckbox
                end tell
            on error
                delay 0.1
            end try
            
        end repeat
    end tell
end run
